#include <iostream>
#include "StMouse.h"

/// <summary>
/// This is a callback function that is used to receive mouse data from StMouse instance.
/// </summary>
/// <param name="sP">New mouse data object</param>
void DataReceived(StPosition sP)
{
	if (sP.S != INT_MIN)
		std::cout << "S: " << sP.S << " ";

	if (sP.X != INT_MIN)
		std::cout << "X: " << sP.X << " ";

	if (sP.Y != INT_MIN)
		std::cout << "Y: " << sP.Y << " ";

	if (sP.Z != INT_MIN)
		std::cout << "Z: " << sP.Z << " ";

	if (sP.S != INT_MIN || sP.X != INT_MIN || sP.Y != INT_MIN || sP.Z != INT_MIN)
		std::cout << std::endl;
}

/// <summary>
/// Entry point of console application.
/// </summary>
/// <returns></returns>
int main()
{
	std::cout << "StMouse FTD2XX Console Test v2.0.4 !\n";

	// Create StMouse instance.
	StMouse stm;
	// StMouse instance allows to connect FTDI USB devices based on index or serial number.
	// If more than one device is present, they will be indexed as 0,1,2,..etc.
	// If just one device is present, it can be connected at index 0.
	// For this sample, supposing one device is connected. We connect at index 0.
	BOOL ret = stm.Connect(0);
	if (ret) {
		std::cout << "Connected... !\n";
		// Once connected, use the setDCallback function to subsribe to mouse data updates.
		stm.setDCallback(DataReceived);
	}
	else {
		std::cout << "Error - Failed to connect to device. Err = "<< StMouse::GetErrorString(stm.LastCallStatus) << std::endl;
	}

	std::cout << "Press Enter key to disconnect/close.";
	(void)getchar();
	// To unsubscribe and close StMouse device connection, call Close().
	stm.Close();
}